if (!localStorage.getItem("user_id")) {
    localStorage.setItem("user_id", crypto.randomUUID());
}
const userId = localStorage.getItem("user_id");

document.getElementById("sendBtn").addEventListener("click", async () => {
    const prompt = document.getElementById("userInput").value;
    const responseDiv = document.getElementById("response");
    responseDiv.innerText = "Generating response...";

    const res = await fetch("https://yourdomain.com/generate_reply.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ prompt, user_id: userId })
    });
    const data = await res.json();
    const reply = data.choices?.[0]?.message?.content || data.error || "No response.";
    responseDiv.innerText = reply;

    const history = JSON.parse(localStorage.getItem("chatHistory") || "[]");
    history.push({ prompt, reply, time: new Date().toISOString() });
    localStorage.setItem("chatHistory", JSON.stringify(history));
});