<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

$apiKey = 'YOUR_OPENAI_API_KEY_HERE';  // Replace with your actual API key

$data = json_decode(file_get_contents("php://input"), true);
$prompt = $data["prompt"] ?? "";
$userId = $data["user_id"] ?? "";

if (!$prompt || !$userId) {
    echo json_encode(["error" => "Prompt or user ID missing"]);
    exit;
}

// Optional: Fetch previous chats for context
$mysqli = new mysqli("localhost", "db_user", "db_pass", "db_name");
if ($mysqli->connect_errno) {
    echo json_encode(["error" => "Failed to connect to DB"]);
    exit;
}

$pastMessages = [];
$stmt = $mysqli->prepare("SELECT prompt, reply FROM chat_history WHERE user_id = ? ORDER BY created_at DESC LIMIT 3");
$stmt->bind_param("s", $userId);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $pastMessages[] = ["role" => "user", "content" => $row["prompt"]];
    $pastMessages[] = ["role" => "assistant", "content" => $row["reply"]];
}
$stmt->close();

$messages = array_merge(
    [["role" => "system", "content" => "You are a professional and empathetic customer support assistant."]],
    $pastMessages,
    [["role" => "user", "content" => $prompt]]
);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.openai.com/v1/chat/completions");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
    "model" => "gpt-4",
    "messages" => $messages,
    "temperature" => 0.7
]));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
    "Authorization: Bearer " . $apiKey
]);

$response = curl_exec($ch);
if (curl_errno($ch)) {
    echo json_encode(["error" => curl_error($ch)]);
} else {
    $responseData = json_decode($response, true);
    $reply = $responseData["choices"][0]["message"]["content"] ?? "";

    // Store chat in database
    $stmt = $mysqli->prepare("INSERT INTO chat_history (user_id, prompt, reply) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $userId, $prompt, $reply);
    $stmt->execute();
    $stmt->close();

    echo $response;
}
curl_close($ch);
?>